/********************************
 *  Seengreat 1.44 Inch LCD Display demo
 *  Author(s):Andy Li from Seengreat
 * ********************/
 
#include <string.h>
#include <stdlib.h>		
#include <wiringPiSPI.h>
#include <wiringPi.h>
#include <softPwm.h>
#include "DEV_Config.h"
#include "lcd_0inch96.h"


/*******************************************************************************
function:
	Hardware reset
*******************************************************************************/
static void Lcd_Reset(void)
{
	DEV_Digital_Write(PIN_CS, 1);
	DEV_Delay_ms(100);
	DEV_Digital_Write(PIN_RST, 0);
	DEV_Delay_ms(100);
	DEV_Digital_Write(PIN_RST, 1);
	DEV_Delay_ms(100);
}

/*******************************************************************************
function:
		Write data and commands
*******************************************************************************/
static void Spi_write_cmd(u_char data)	 
{	
	DEV_Digital_Write(PIN_CS, 0);
	DEV_Digital_Write(PIN_DC, 0);
	DEV_SPI_WriteByte(data);
}

static void Spi_write_data(u_char data) 
{	
	DEV_Digital_Write(PIN_CS, 0);
	DEV_Digital_Write(PIN_DC, 1);
	DEV_SPI_WriteByte(data);
	DEV_Digital_Write(PIN_CS,1);
}  

void Spi_write_word(u_int16_t data)
{
	DEV_Digital_Write(PIN_CS, 0);
	DEV_Digital_Write(PIN_DC, 1);
	DEV_SPI_WriteByte((data>>8) & 0xff);
	DEV_SPI_WriteByte(data & 0xff); 
	DEV_Digital_Write(PIN_CS, 1);
}	  


/******************************************************************************
function:	
		Common register initialization
******************************************************************************/
void Lcd_Init(void)
{
	if(DEV_ModuleInit() != 0){
        DEV_ModuleExit();
        exit(0);
    }
	Lcd_Reset();

	//************* Start Initial Sequence **********// 
	Spi_write_cmd(0x11);//Sleep exit 
	DEV_Delay_ms(120);
	Spi_write_cmd(0x21); 
	Spi_write_cmd(0x21); 

	Spi_write_cmd(0xB1); 
	Spi_write_data(0x05);
	Spi_write_data(0x3A);
	Spi_write_data(0x3A);

	Spi_write_cmd(0xB2);
	Spi_write_data(0x05);
	Spi_write_data(0x3A);
	Spi_write_data(0x3A);

	Spi_write_cmd(0xB3); 
	Spi_write_data(0x05);  
	Spi_write_data(0x3A);
	Spi_write_data(0x3A);
	Spi_write_data(0x05);
	Spi_write_data(0x3A);
	Spi_write_data(0x3A);

	Spi_write_cmd(0xB4);
	Spi_write_data(0x03);

	Spi_write_cmd(0xC0);
	Spi_write_data(0x62);
	Spi_write_data(0x02);
	Spi_write_data(0x04);

	Spi_write_cmd(0xC1);
	Spi_write_data(0xC0);

	Spi_write_cmd(0xC2);
	Spi_write_data(0x0D);
	Spi_write_data(0x00);

	Spi_write_cmd(0xC3);
	Spi_write_data(0x8D);
	Spi_write_data(0x6A);   

	Spi_write_cmd(0xC4);
	Spi_write_data(0x8D); 
	Spi_write_data(0xEE); 

	Spi_write_cmd(0xC5);  /*VCOM*/
	Spi_write_data(0x0E);    

	Spi_write_cmd(0xE0);
	Spi_write_data(0x10);
	Spi_write_data(0x0E);
	Spi_write_data(0x02);
	Spi_write_data(0x03);
	Spi_write_data(0x0E);
	Spi_write_data(0x07);
	Spi_write_data(0x02);
	Spi_write_data(0x07);
	Spi_write_data(0x0A);
	Spi_write_data(0x12);
	Spi_write_data(0x27);
	Spi_write_data(0x37);
	Spi_write_data(0x00);
	Spi_write_data(0x0D);
	Spi_write_data(0x0E);
	Spi_write_data(0x10);

	Spi_write_cmd(0xE1);
	Spi_write_data(0x10);
	Spi_write_data(0x0E);
	Spi_write_data(0x03);
	Spi_write_data(0x03);
	Spi_write_data(0x0F);
	Spi_write_data(0x06);
	Spi_write_data(0x02);
	Spi_write_data(0x08);
	Spi_write_data(0x0A);
	Spi_write_data(0x13);
	Spi_write_data(0x26);
	Spi_write_data(0x36);
	Spi_write_data(0x00);
	Spi_write_data(0x0D);
	Spi_write_data(0x0E);
	Spi_write_data(0x10);

	Spi_write_cmd(0x3A); 
	Spi_write_data(0x05);

	Spi_write_cmd(0x36);
	Spi_write_data(0xA8);

	Spi_write_cmd(0x29);
	DEV_Delay_ms(50);
}


//select the srceen area(from point(start_x,start_y) to point(end_x,end_y))
void Set_Window(u_int16_t start_x, u_int16_t start_y, u_int16_t end_x, u_int16_t  end_y)
{ 
	start_x += 1;
	end_x += 1;
	start_y += 26;
	end_y += 26;
	Spi_write_cmd(0x2a);
	Spi_write_data(start_x >>8);
	Spi_write_data(start_x & 0xff);
	Spi_write_data(end_x >> 8);
	Spi_write_data(end_x & 0xff);

	Spi_write_cmd(0x2b);
	Spi_write_data(start_y >>8);
	Spi_write_data(start_y & 0xff);
	Spi_write_data(end_y >> 8);
	Spi_write_data(end_y & 0xff);

	Spi_write_cmd(0x2C);
}


//set cursor to the point(x, y)
void Set_Cursor(u_int16_t x, u_int16_t y)
{ 
	x += 1;
	y += 26;
	Spi_write_cmd(0x2a);
	Spi_write_data(x >> 8);
	Spi_write_data(x);
	Spi_write_data(x >> 8);
	Spi_write_data(x);

	Spi_write_cmd(0x2b);
	Spi_write_data(y >> 8);
	Spi_write_data(y);
	Spi_write_data(y >> 8);
	Spi_write_data(y);

	Spi_write_cmd(0x2C);
}

//refresh the entire screen to color
void Lcd_Clear(u_int16_t color)
{
	u_int16_t i;
	u_int16_t image[LCD_W * LCD_H];
	for(i=0;i<LCD_W * LCD_H;i++)
	{
		image[i] = color>>8 | (color&0xff)<<8;
	}
	Set_Window(0, 0, LCD_W-1, LCD_H-1);
	DEV_Digital_Write(PIN_DC, 1);
	for(i = 0; i < LCD_H; i++)
	{
		DEV_SPI_Write_nByte((uint8_t *)&image[i*LCD_W], LCD_W*2); 
	}
}


//display the image to whole screen 
void Display(u_int16_t *image)
{
	u_int16_t i;
	u_int16_t p[LCD_SIZE];
    memcpy(p,image,LCD_SIZE);
	Set_Window(0, 0, LCD_W-1, LCD_H-1);
	DEV_Digital_Write(PIN_DC, 1);
	for(i = 0; i < LCD_H; i++)
	{
		DEV_SPI_Write_nByte((uint8_t *)p+LCD_W*2*i, LCD_W*2);
	}
}

//set the point(x,y) to color
void Draw_Point(u_int16_t x, u_int16_t y, u_int16_t Color)
{
	Set_Cursor(x, y);
	Spi_write_word(Color); 	    
}

